using System;
using System.Windows.Forms;
using System.Collections;
using System.Diagnostics;
using RootPro.RootProCAD;
using RootPro.RootProCAD.Command;
using RootPro.RootProCAD.Geometry;

////////////////////////////////////////////////////////////////////////////////
// }` (/A) 폜AhC
// w肵lA}` (/A) 폜܂B
////////////////////////////////////////////////////////////////////////////////

namespace RCAddInSmallCleanCS
{
    public partial class RootProCADApplication
    {
        string CleanSmallShapesCommandName = "RootPro.AddIn.CreanSmallShapeCommand";     //R}h 

        private void RootProCADApplication_Startup(object sender, EventArgs e)
        {
            CommandManager.AddMacroCommand("}`̍폜", CleanSmallShapes);

            //R}hǉ
            Command command = CommandManager.AddCommand(CleanSmallShapesCommandName, "}`̍폜");

            command.ParameterGroups.Add(ParameterItemType.Double, 0, "폜臒l");
            DoubleParameterItem doubleParameterItem = (DoubleParameterItem)command.GetParameterItemByID(0);
            doubleParameterItem.Description = "폜臒lw肵܂";
            doubleParameterItem.ValueSaveMode = ParameterValueSaveMode.OneTime;
//            doubleParameterItem.Value = 2;
//            doubleParameterItem.ValueSaveMode = ParameterValueSaveMode.Always;

            //JnCxgƏICxg̒ǉ
            command.Begin += new CommandBeginEventHandler(command_Begin);
            command.End += new EventHandler(command_End);

        }

        private void RootProCADApplication_Shutdown(object sender, EventArgs e)
        {
            CommandManager.RemoveMacroCommand(CleanSmallShapes);
            CommandManager.RemoveCommand(CleanSmallShapesCommandName);
        }

        #region VSTA generated code
        private void InternalStartup()
        {
            this.Startup += new System.EventHandler(RootProCADApplication_Startup);
            this.Shutdown += new System.EventHandler(RootProCADApplication_Shutdown);
        }
        #endregion


        /// <summary>
        /// }NR}h̎s
        /// </summary>
        private void CleanSmallShapes()
        {
            //R}h̎s
            CommandManager.ExecuteCommand(CleanSmallShapesCommandName);
        }

        /// <summary>
        /// R}h̊JnɌĂ΂
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void command_Begin(Object sender, CommandBeginEventArgs e)
        {
            Command command = (Command)sender;

            //p[^ύXCxg̒ǉ
            command.ParameterChanged += new CommandParameterChangedEventHandler(command_ParameterChanged);
        }

        /// <summary>
        /// R}h̏IɌĂ΂
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void command_End(Object sender, EventArgs e)
        {
            Command command = (Command)sender;

            //p[^ύXCxg̍폜
            command.ParameterChanged -= new CommandParameterChangedEventHandler(command_ParameterChanged);
        }


        /// <summary>
        /// ts
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void command_ParameterChanged(Object sender, CommandParameterChangedEventArgs e)
        {
            Document doc = ActiveDocument;         //hLg̎擾

            Command command = (Command)sender;
            int id = e.ParameterID;// ύX̂p[^ID
            ParameterItem parameterItem = command.GetParameterItemByID(id); // p[^ACe

            //̎擾
            DoubleParameterItem doubleParameterItem = (DoubleParameterItem)parameterItem;
            if (doubleParameterItem.IsEmpty)
                return;
            double cleanValue = doubleParameterItem.Value;
            if (cleanValue > 100.0 )
            {
                MessageBox.Show("100.0 ȉ̒lw肵ĂB");
                e.CommandState = CommandState.ParameterError;
                return;
            }


            // UNDO \ȑJn
            doc.UndoManager.BeginUndoUnit();

            //Ԍv
            Stopwatch sw = new Stopwatch();
            sw.Start();

            //}`̍쐬
            int deleteCount =DoCleanSmallShapes (cleanValue);

            sw.Stop();

            e.CommandState = CommandState.Execute;

            // UNDO \ȑI
            doc.UndoManager.EndUndoUnit();

            //ʂ̕\
            MessageBox.Show(deleteCount.ToString() + " ̐}`폜܂B", "}`̍폜", MessageBoxButtons.OK, MessageBoxIcon.Information);

            long millisec = sw.ElapsedMilliseconds;
            Trace.WriteLine(" " + millisec + " (msec)");
            Trace.Flush();

        }

        /// <summary>
        /// }`̍폜̎s
        /// </summary>
        /// <param name="cleanValue"></param>
        /// <returns></returns>
        private int DoCleanSmallShapes(double cleanValue)
        {
            int deleteCount = 0;
            Document doc = ActiveDocument;			//hLg̎擾
            int count = doc.Drawings.Count;
            for (int i = 0; i < count; i++)
            {
                Drawing drawing = doc.Drawings[i];

                ArrayList deleteShapeArray = new ArrayList();
                //}`񋓂
                int shapeCount = drawing.Shapes.Count;
                Shape shape = null;
                while ((shape = drawing.Shapes.GetNextShape(shape)) != null)
                {
                    //ʃtH[ɒǉ
                    if (IsCleanShape(shape, cleanValue))
                    {
                        deleteShapeArray.Add(shape);        //폜Xgɒǉ
                    }
                }

                foreach (Shape deleteShape in deleteShapeArray)
                {
                    //}`̍폜
                    drawing.Shapes.Remove(deleteShape);
                    deleteCount++;
                }
            }

            return deleteCount;
        }


        /// <summary>
        /// 폜}`
        /// </summary>
        /// <param name="shape"></param>
        /// <param name="cleanValue"></param>
        /// <returns></returns>
        private bool IsCleanShape(Shape shape, double cleanValue)
        {
            if (shape is LineShape)
            {
                return ((LineShape)shape).Length < cleanValue;
            }
            else if (shape is PolylineShape)
            {
                return ((PolylineShape)shape).Length < cleanValue;
            }
            else if (shape is CircleShape)
            {
                return ((CircleShape)shape).Radius < cleanValue;
            }
            else if (shape is ArcShape)
            {
                return ((ArcShape)shape).Radius < cleanValue;
            }
            else if (shape is EllipseShape)
            {
                return ((EllipseShape)shape).MajorRadius < cleanValue;
            }
            else if (shape is EllipseArcShape)
            {
                return ((EllipseArcShape)shape).MajorRadius < cleanValue;
            }

            return false;
        }
    }
}
